function doAjax(getOrPost,url,data,fct,errorMsg) {
	$.ajax({ type: getOrPost,   
        url: url, 
        dataType: "json",
        data: data,
        async: false,
        success : function(answer)
        {
        	if (fct != null) {
        		fct(answer);
        	}
        },
		error: function( text ) {
			if (errorMsg != null) {
				alert( "Kommunikationsfehler zum Server: " + errorMsg);
			} else {
				// do nothing
			}
		}
	});
}

function doAjaxTransmitValue(getOrPost,url,data,fct,aValue,errorMsg) {
	$.ajax({ type: getOrPost,   
        url: url, 
        dataType: "json",
        data: data,
        async: false,
        success : function(answer)
        {
        	if (fct != null) {
        		fct(answer,aValue);
        	}
        },
		error: function( text ) {
			if (errorMsg != null) {
				alert( "Kommunikationsfehler zum Server: " + errorMsg);
			} else {
				// do nothing
			}
		}
	});
}

function toHtml(text) {
	if (typeof text === 'string') {
		return (text.replace(/"/g, '&quot;').replace(/</g, "&lt;").replace(/>/g, "&gt;"));
	} else {
		return text;
	}
}

function reloadPage(url) {
	// use a timeout so that also Chrome does always a reload
	setTimeout(function(){document.location.href = url},250);
}

/**
 * Bind the logout button: log out the user and forward him to login page
 */
function bindLogout() {
	$("#logoutbtn").off("click").on("click", function (e) {
		e.stopImmediatePropagation();
			e.preventDefault();
			doAjax("POST", "php/generals.php?command=logout", null, handleLogout, null);
		});
}

/**
 * Logout button action completed -> forward to login page (index.html)
 * @param status
 */
function handleLogout(status) {
	// status is always OK -> just reload the page
	reloadPage("index.html");
}

function insertSpiderVersion(version) {
	$("#spiderversion").html(version);
}