<?php
require_once ('config.php');
require_once ('database/database.php');
require_once ('globals.php');
require_once ('utils.php');

$command = $_GET["command"];

if ($command == 'isInstalled') {
	isInstalled();
} else if ($command == 'getSpiderVersion') {
	getSpiderVersion();
} else if ($command == 'isUserLoggedIn') {
	isUserLoggedIn();
} else if ($command == 'login') {
	login($_POST["authcode"]);
} else if ($command == 'logout') {
	logout();
} else if ($command == 'setrate') {
	setRate($_POST["rate"]);
} else if ($command == "getrate") {
	getRate();
} else {
	echo "unknown command";
}

function isInstalled() {
	if(defined('INSTALLSTATUS')){
		if (INSTALLSTATUS == 'new') {
			echo json_encode("No");
		} else {
			echo json_encode("Yes");
		}
	}
}

function getSpiderVersion() {
	$pdo = DbUtils::openDbAndReturnPdo();
	if (is_null($pdo)) {
		echo json_encode("");
		return;
	}
	$sql = "SELECT setting FROM %config% WHERE name=?";
	$stmt = $pdo->prepare(DbUtils::substTableAlias($sql));
	$stmt->execute(array("version"));
	if ($stmt->rowCount() > 0) {
		echo json_encode($stmt->fetchObject()->setting);
	} else {
		echo json_encode("");
	}
}

function setRate($rate) {
	if (isUserLoggedInCore()) {
		$pdo = DbUtils::openDbAndReturnPdo();
		Database::setRefreshRate($pdo, null, $rate);
	}
	echo json_encode(array("status" => array(ACTION_OK,ACTION_OK_MSG)));
}

function getRate() {
	if (isUserLoggedInCore()) {
		$pdo = DbUtils::openDbAndReturnPdo();
		$rate = Database::getConfigItem($pdo,'refreshrate');
		echo json_encode(array("status" => array(ACTION_OK,ACTION_OK_MSG), "rate" => $rate));
	}
}

function isUserLoggedIn() {
	if (isUserLoggedInCore()) {
		echo json_encode("YES");
	} else {
		echo json_encode("NO");
	}
}

function login($password) {
	$authenticated = false;
	$pdo = DbUtils::openDbAndReturnPdo();
	if (is_null($pdo)) {
		echo json_encode(NO);
		return;
	}
	$authCode = Database::getConfigItem($pdo, "accesspassword");
	
	if ($password == $authCode) {
		$authenticated = true;
	}

	if ($authenticated) {
		if(session_id() == '') {
			session_start();
		}
		$_SESSION['loggedin'] = true;
	}

	if ($authenticated) {
		echo json_encode(YES);
	} else {
		echo json_encode(NO);
	}
}

function logout() {
	if(session_id() == '') {
		session_start();
		session_destroy();
	}
	echo json_encode(YES);
}

?>