<?php
// Data base configuration and a bit more
require_once ('config.php');

define ('DB_CONFIG_TABLE', TAB_PREFIX . 'config');

class DbUtils {
	/**
	 * Open a PDO connection to the database based on the config.php file that
	 * is written during the installation
	 * 
	 * @return NULL|PDO: null if no connection could be established, otherwise the PDO instance
	 */
	public static function openDbAndReturnPdo() {
		$dsn = 'mysql:host=' . MYSQL_HOST . ';dbname=' . MYSQL_DB;
		$user = MYSQL_USER;
		$password = MYSQL_PASSWORD;
		$pdo = null;
		try {
			$pdo = new PDO($dsn, $user, $password);
			$pdo ->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		}
		catch (PDOException $e) {
			return null;
		}
		return $pdo;
	}
	
	/*
	 * To use sql strings that are easy to read the table names are used
	 * without variables. But since the user can specify a prefix for all
	 * tables the substitution must be done somewhere. This is the function
	 * that replaces the %TABLE% by $prefix_table
	 */
	public static function substTableAlias($sqlString) {
		return self::substTableAliasWithPrefix($sqlString, TAB_PREFIX);
	}
	
	/**
	 * Like substTableAlias, but can be used with a defined prefix
	 * 
	 * @param unknown $sqlString
	 * @param unknown $prefix
	 * @return mixed
	 */
	public static function substTableAliasWithPrefix($sqlString,$prefix) {
		$out = $sqlString;
		$out = str_replace("%config%",$prefix . "config",$out);
		$out = str_replace("%clients%",$prefix . "clients",$out);
	
		return ($out);
	}
}
?>