<?php

/*
 * This part fetches the information from the various clients. It is necessary
 * to use this PHP class instead of doing this on the client side by JavaScript
 * because the "same origin policy" does not allow this on the client side.
 */

require_once ('config.php');
require_once ('database/database.php');
require_once ('globals.php');
require_once ('utils.php');

$command = $_GET["command"];

if ($command == 'isloggedin') {
	echo json_encode(isUserLoggedInCore() ? "YES" : "NO");
}

if (!isUserLoggedInCore()) {
	return;
}

if ($command == 'getclientversion') {
	getClientVersion($_POST['clientid']);
} else if ($command == 'getlastclosings') {
	getLastClosings($_POST['clientid'],$_POST['number']);
} else if ($command == 'getopentables') {
	getOpenTables($_POST['clientid']);
} else if ($command == 'getreport') {
	getReport($_POST['clientid']);
} else if ($command == 'getwaitermessage') {
	getWaiterMessage($_POST['clientid']);
} else if ($command == 'getloginmessage') {
	getLoginMessage($_POST['clientid']);
} else if ($command == 'sendwaitermessage') {
	sendWaiterMessage($_POST['clientid'],$_POST['message']);
} else if ($command == 'sendloginmessage') {
	sendLoginMessage($_POST['clientid'],$_POST['message']);
}

/**
 * Get the version of a client.
 * @param unknown $clientid
 */
function getClientVersion($clientid) {
	getDataFromClient($clientid,"getVersion",array());
}

/**
 * Get the last closings of a client.
 * @param unknown $clientid
 * @param unknown $number
 */
function getLastClosings($clientid,$number) {
	$data = array('number' => "$number");
	getDataFromClient($clientid,"getLastClosings",$data);
}

/**
 * Get the sum of still unpaid tables and the number of open tables.
 * @param unknown $clientid
 */
function getOpenTables($clientid) {
	getDataFromClient($clientid,"getOpenTables",array());
}

function getReport($clientid) {
	getDataFromClient($clientid,"getReport",array());
}

function getWaiterMessage($clientid) {
	getDataFromClient($clientid,"getWaiterMessage",array());
}

function sendWaiterMessage($clientid,$message) {
	getDataFromClient($clientid,"sendWaiterMessage",array("message" => $message));
}

function getLoginMessage($clientid) {
	getDataFromClient($clientid,"getLoginMessage",array());
}

function sendLoginMessage($clientid,$message) {
	getDataFromClient($clientid,"sendLoginMessage",array("message" => $message));
}

/**
 * Fetch the parameters of a client with the given clientid from the data base
 * by use of the remote access command of that client.
 */
function getDataFromClient($clientid,$command,$data) {
	$pdo = DbUtils::openDbAndReturnPdo();
	$sql = "SELECT * FROM %clients% WHERE id=?";
	$stmt = $pdo->prepare(DbUtils::substTableAlias($sql));
	$stmt->execute(array($clientid));
	if ($stmt->rowCount() > 0) {
		$client =$stmt->fetchObject();
		$clientname = $client->name;
		$clienturl = $client->url . "/php/remoteaccess.php?command=$command";
		$clientaccesscode = $client->remoteaccesscode;
		$clientAuthUser = $client->basicauthuser;
		$clientAuthPass = $client->basicauthpass;
	}

	$data = array_merge($data,array('remoteaccesscode' => "$clientaccesscode"));
	
	$query = http_build_query($data);
	$opts = array(
			'http'=>array(
					'header' => "Content-Type: application/x-www-form-urlencoded\r\n".
						"Authorization: Basic " . base64_encode("$clientAuthUser:$clientAuthPass") .
						"Content-Length: ".strlen($query)."\r\n".
						"User-Agent:MyAgent/1.0\r\n",

					'method'  => 'POST',
					'content' => $query
			)
	);
	
	$context = stream_context_create($opts);
	
	// Open the file using the HTTP headers set above
	$file = file_get_contents($clienturl, false, $context);

	echo $file;
}
