/**
 * 
 */

function Client (id,name,url,remoteaccesscode,basicAuthUser,basicAuthPassword,remark) {
	this.id = id;
	this.name = name;
    this.url = url;
    this.remoteaccesscode = remoteaccesscode;
    this.basicAuthUser = basicAuthUser;
    this.basicAuthPassword = basicAuthPassword;
    this.remark = remark;
}

/**
 * Display the parameters of a client as an HTML form.
 * 
 * @returns {String}
 */
Client.prototype.showSettings = function() {
	var txt = "";
	if (this.id == "new") {
		txt += "<tr><td><input value='' placeholder='" + this.name + "' id='client_name_" + this.id + "'/>";
		txt += "<td><input value='' placeholder='" + this.url + "' id='client_url_" + this.id + "'/>";
		txt += "<td><input value='' placeholder='" + this.remoteaccesscode + "' id='client_remoteaccesscode_" + this.id + "'/>";
		txt += "<td><input value='' placeholder='" + this.basicAuthUser + "' id='client_basicAuthUser_" + this.id + "'/>";
		txt += "<td><input value='' placeholder='" + this.basicAuthPassword + "' id='client_basicAuthPassword_" + this.id + "'/>";
		txt += "<td><input value='' placeholder='" + this.remark + "' id='client_remark_" + this.id + "'/>";
		txt += "<td><input value='Neu anlegen' id='createNewClient' type='button' />";
		txt += "</tr></table></form>";
	} else {
		txt += "<tr><td><input value='" + this.name + "' id='client_name_" + this.id + "'/>";
		txt += "<td><input value='" + this.url + "' id='client_url_" + this.id + "'/>";
		txt += "<td><input value='" + this.remoteaccesscode + "' id='client_remoteaccesscode_" + this.id + "'/>";
		txt += "<td><input value='" + this.basicAuthUser + "' id='client_basicAuthUser_" + this.id + "'/>";
		txt += "<td><input value='" + this.basicAuthPassword + "' id='client_basicAuthPassword_" + this.id + "'/>";
		txt += "<td><input value='" + this.remark + "' id='client_remark_" + this.id + "'/>";
		txt += "<td><input value='Ändern' id='changeClient_" + this.id + "' type='button' />";
		txt += "&nbsp;&nbsp;<input value='Löschen' id='deleteClient_" + this.id + "' type='button' />";
		txt += "</tr>";
	}
	return txt;
};

/**
 * Bind the action buttons (create new client, delete or change clients settings) to the 
 * functions that are responsible for its execution.
 */
Client.prototype.handleactions = function() {
	var self = this;
	$("#changeClient_" + this.id).off("click").on("click", function (e) {
  			e.stopImmediatePropagation();
  			e.preventDefault();
  			var data = self.getData(this.id.split("_")[1]);
  			doAjax("POST","php/clients.php?command=changeclient",data,self.handleactionresult,"Kommunikationsfehler");
	});
	$("#deleteClient_" + this.id).off("click").on("click", function (e) {
			e.stopImmediatePropagation();
			e.preventDefault();
			var data = self.getData(this.id.split("_")[1]);
			doAjax("POST","php/clients.php?command=deleteclient",data,self.handleactionresult,"Kommunikationsfehler");
	});
	$("#createNewClient").off("click").on("click", function (e) {
		e.stopImmediatePropagation();
		e.preventDefault();

		var data = self.getData("new");
		doAjax("POST","php/clients.php?command=createclient",data,self.handleactionresult,"Kommunikationsfehler");
	});
}


/**
 * Read the parameters of an instance from the web UI and add the "id" to the data set.
 * 
 * @param id id of the client (is used also in the id of the html input fields)
 * @returns an object that contains the data in a format that can be handled by the PHP client methods
 */
Client.prototype.getData = function(id) {
	var data = {
			id:id,
			name:$("#client_name_" + id).val(),
			url:$("#client_url_" + id).val(),
			code:$("#client_remoteaccesscode_" + id).val(),
			basicauthuser:$("#client_basicAuthUser_" + id).val(),
			basicauthpass:$("#client_basicAuthPassword_" + id).val(),
			remark:$("#client_remark_" + id).val()
	};
	return data;
}

/**
 * Handle the answer of an AJAX call to create, change or delete a client
 * @param answer
 */
Client.prototype.handleactionresult = function(answer) {
	if (answer.status[0] == 1) {
		reloadPage(window.location.href);
	} else {
		alert("Fehler: " + answer.status[1]);
	}
}
