#
#             Skript für Windows zum Anpassen der php.ini
#
#
# Mit diesem Skript können die Anpassungen in der php.ini vorgenommen werden. Statt nun händisch
# alle Änderungen mit einem Texteditor in der php.ini vorzunehmen, kann man dieses Skript auf der 
# Kommandozeile (cmd.exe) ausführen. Die Änderungen werden erst nach Neustart des Webservers appliziert.
#
# Allerdings kann das Skript nicht selbstständig herausfinden, wo die vom Webserver verwendete Datei
# php.ini im Dateisystem liegt. Bei einer Standardinstallation von xampp ist dies:
# "c:\xampp\php\php.ini", kann aber natürlich bei einer angepassten Installation oder Verwendung
# eines anderen WAMP-Stacks an anderer Stelle liegen. Daher ist der Pfad in der Variable $phpfile
# möglicherweise anzupassen:

$phpfile = 'c:\xampp\php\php.ini'

# --------------------------------------------------------------------------------------
# Der Teil ab hier ist nur für Entwickler interessant, die das Skript anpassen wollen:
# --------------------------------------------------------------------------------------

# Nutzung eines temporären Verzeichnis, um die veränderte php.ini zwischenzuspeichern:
$tempfolder = [System.IO.Path]::GetTempPath()
echo "Using temporary folder: $tempfolder"
$tempfile = "$tempfolder" + "newphp.ini"
echo "Writing php.ini temporarily into $tempfile"


# Setzen des memory_limit in Abhängigkeit vom physikalisch verbauten RAM (30%). Dazu
# wird eine regex erstellt:

$ramsize = (Get-CimInstance Win32_PhysicalMemory | Measure-Object -Property capacity -Sum).sum
echo "Total RAM available: $ramsize"
$tobeused = (($ramsize - ($ramsize * 0.3)) / (1024 * 1024)).ToString() + "M"
echo "RAM for PHP: $tobeused"
$pat1 = '(memory_limit)=(.*)'
$pat2 = '$1=' + $tobeused

# Setzen der anderer Parameter, die nicht vom System abhängig sind:

# max_execution_time=1200
# post_max_size=80000M
# upload_max_filesize=80000M
# max_input_vars = 10000 (damit auch größere Bestellungen in einem Rutsch an den Server geschickt werden können)
# ;extension=gd (in neueren xampp-Versionen ist die gd-Library einkommentiert, aber OrderSprinter benötigt gd)

# Nach diesen Vorbereitungen werden die Ersetzungen nun in einem Rutsch vorgenommen:

(Get-Content $phpfile) `
    -replace $pat1,$pat2 `
	-replace '(post_max_size)=(.*)','$1=80000M' `
	-replace '(;)(max_input_vars)(.*)=(.*)','$2=10000' `
	-replace '(upload_max_filesize)=(.*)','$1=80000M' `
	-replace '(;)(extension=gd)','$2' `
    -replace '(max_execution_time)=(.*)', '$1=1200' |
  Out-File x.txt  -Encoding Ascii

# Im letzten Schritt wird die originale php.ini wieder überschrieben:
  
Copy-Item $tempfile -Destination $phpfile
