<?php

require_once 'php/dbutils.php';
require_once 'php/config.php';
defined('DB') || define ( 'DB','mysql' );


class Sync {
	public static function insertSystemData($pdo,$systemdata) {
		try {
			DbUtils::log("insertSystemData started");
			if (!isset($systemdata["guestcode"])) {
				return array("status" => "ERROR","msg" => "No Access code transmitted!");
			}
			
			$transmittedGuestcode = $systemdata["guestcode"];
			if ($transmittedGuestcode != CODE) {
				return array("status" => "ERROR","msg" => "Wrong Access code!");
			}

			self::insertIntoSystemTable($pdo, $systemdata, 'timezone');
			self::insertIntoSystemTable($pdo, $systemdata, 'dailycode');
			self::insertIntoSystemTable($pdo, $systemdata, 'resttables');
			self::insertIntoSystemTable($pdo, $systemdata, 'types');
			self::insertIntoSystemTable($pdo, $systemdata, 'products');
                        self::insertIntoSystemTable($pdo, $systemdata, 'extras');
			self::insertIntoSystemTable($pdo, $systemdata, 'currency');
			self::insertIntoSystemTable($pdo, $systemdata, 'guesttheme');
                        self::insertIntoSystemTable($pdo, $systemdata, 'guestarticleconfirm');
			self::insertIntoSystemTable($pdo, $systemdata, 'theme');
			self::insertIntoSystemTable($pdo, $systemdata, 'decpoint');
			
			self::insertIntoSystemTable($pdo, $systemdata, 'askdaycode');
			self::insertIntoSystemTable($pdo, $systemdata, 'asktablecode');
			self::insertIntoSystemTable($pdo, $systemdata, 'guesttimeout');
			
			if (isset($systemdata["timezone"])) {
				self::updateOsAccessStatus($pdo, $systemdata["timezone"]);
			}
			$logo = '';
			if (isset($systemdata["logo"]) && ($systemdata["logo"] != '')) {
				$logo = $systemdata["logo"];	
			}
			self::insertOrUpdateOrDeleteImage($pdo, 'logo', $logo, DbUtils::$TYPE_LOGO, null);

			if (isset($systemdata["prodimages"])) {
				DbUtils::log("prodimages are transmitted -> update now");
				self::insertOrUpdateProdImages($pdo, $systemdata["prodimages"]);
			}
			return array("status" => "OK");
		} catch (Exception $ex) {
			return array("status" => "ERROR","msg" => $ex->getMessage());
		}
	}
	
	
	private static function deleteImage_not_used($pdo,$imageName,$productid) {
		if (DB == "mysql") {
			if (is_null($productid)) {
				$sql = "DELETE FROM %images% WHERE imagename=?";
				DbUtils::execSql($pdo, $sql, array($imageName));
			} else {
				$sql = "DELETE FROM %images% WHERE productid=?";
				DbUtils::execSql($pdo, $sql, array($productid));
			}
		} else {
			
		}
	}
	
	private static function insertOrUpdateOrDeleteImage($pdo,$imageName,$content,$contenttype,$productid) {
		$contentMd5 = null;
		if ($content == '-') {
			$content = '';
		}
		if (!is_null($content)) {
			$contentMd5 = md5($content);
		}
		if (DB == "mysql") {
			
			if (is_null($productid)) {
				$sql = "SELECT id,content FROM %images% WHERE imagename=?";
				$result = DbUtils::fetchSqlAll($pdo, $sql, array($imageName));
			} else {
				$sql = "SELECT id,content FROM %images% WHERE productid=?";
				$result = DbUtils::fetchSqlAll($pdo, $sql, array($productid));
			}
			
			$delete = false;
			if (!is_null($productid) && ($content == '')) {
				$delete = true;
			} else if (is_null($productid) && ($content == '')) {
				$delete = true;
			}
			if ($delete) {
				if (count($result) > 0) {
					$id = $result[0]["id"];
					$sql = "DELETE FROM %images% WHERE id=?";
					DbUtils::execSql($pdo, $sql, array($id));
					if (!is_null($productid)) {
						DbUtils::log("Product image with id $productid deleted from mysql");
					} else {
						DbUtils::log("Product image with name $imageName deleted from mysql");
					}
				}
				return;
			}
			
			
			if (count($result) == 0) {
				$sql = "INSERT INTO %images% (imagename,content,contenttype,productid) VALUES(?,?,?,?)";
				DbUtils::execSql($pdo, $sql, array($imageName,$content,$contenttype,$productid));
				DbUtils::log("Image with name '" . $imageName . "' and product id=" . (is_null($productid) ? "null":$productid) . " inserted into mysql");
			} else {
				$origContentMd5 = md5($result[0]["content"]);
				if ($contentMd5 != $origContentMd5) {
					$rowId = $result[0]["id"];
					$sql = "UPDATE %images% SET imagename=?,content=?,contenttype=?,productid=? WHERE id=?";
					DbUtils::execSql($pdo, $sql, array($imageName,$content,$contenttype,$productid,$rowId));
					DbUtils::log("Image updated with imagename='$imageName' and productid=" . (is_null($productid) ? "null":$productid) . " in mysql");
				}
			}
		} else {
			try {
				$filename = "db/" . IMAGES_FILE;
				$images = array();
				if (file_exists($filename)) {
					$imagesContent = file_get_contents($filename);
					$images = json_decode($imagesContent,true);
				}

				$imgesWereChanged = false;
				$foundImageAtKey = null;

				$keys = array_keys($images);
				foreach($keys as $aKey) {
					$img = $images[$aKey];
					if (is_null($productid)) {
						if ($img["imagename"] == $imageName) {
							$foundImageAtKey = $aKey;
							break;
						}
					} else {
						if ($img["productid"] == $productid) {
							$foundImageAtKey = $aKey;
							break;
						}
					}
				}
				
				$delete = false;
				if ($imageName == 'logo') {
					DbUtils::log("Logo content: " . $content);
				}
				if (!is_null($productid) && ($content == '')) {
					$delete = true;
				} else if (is_null($productid) && ($content == '')) {
					$delete = true;
				}
				
				if ($delete) {
					if (!is_null($foundImageAtKey)) {
						unset ($images[$foundImageAtKey]);
						file_put_contents($filename, json_encode($images));
						if (!is_null($productid)) {
							DbUtils::log("Product image with id $productid deleted from file");
						} else {
							DbUtils::log("Product image with name $imageName deleted from file");
						}
					}
					return;
				}

				$img = array("imagename" => $imageName,"content" => $content, "contenttype" => $contenttype, "productid" => $productid);
				if (is_null($foundImageAtKey)) {
					$images[] = $img;
					$imgesWereChanged = true;
					DbUtils::log("Image with name '" . $imageName . "' and product id=" . (is_null($productid) ? "null":$productid) . " inserted into file db");		
				} else {
					$origContentMd5 = md5($images[$foundImageAtKey]["content"]);
					if ($contentMd5 != $origContentMd5) {
						$images[$foundImageAtKey] = $img;
						$imgesWereChanged = true;
						DbUtils::log("Image updated with imagename='$imageName' and productid=" . (is_null($productid) ? "null":$productid) . " in file db");
					}
				}
				
				if ($imgesWereChanged) {
					file_put_contents($filename, json_encode($images));
				}
			} catch(Exception $ex) { }
		}
	}
	
	private static function insertOrUpdateProdImages($pdo,$imagedata) {
		foreach ($imagedata as $img) {
			$productid = $img['prodid'];
			$imgl = $img['imagedata'];
			self::insertOrUpdateOrDeleteImage($pdo, '', $imgl, DbUtils::$TYPE_PRODIMG, $productid);	
		}		
	}
	
	private static function insertIntoSystemTable($pdo,$data,$item) {
		if (isset($data[$item])) {
			$value = $data[$item];
			$valuemd5 = md5($value);
			if (DB == "mysql") {
				$sql = "SELECT value FROM %ossystem% WHERE item=?";
				$origvalSql = DbUtils::fetchSqlAll($pdo, $sql, array($item));
				if (count($origvalSql) == 0) {
					$sql = "INSERT INTO %ossystem% (item,value) VALUES(?,?)";
					DbUtils::execSql($pdo, $sql, array($item,$value));
				} else {
					// to avoid unnecessary write operations check if update is needed
					$origvalmd5 = md5($origvalSql[0]["value"]);
					if ($valuemd5 != $origvalmd5) {
						$sql = "UPDATE %ossystem% SET value=? WHERE item=?";
						DbUtils::execSql($pdo, $sql, array($value,$item));
					}
				}				
			} else {
				$filename = "db/" . OSSYSTEM_FILE;
				try {
					if (file_exists($filename)) {
						$allOssystemvalues = file_get_contents($filename);
						$dataItems = json_decode($allOssystemvalues, true);
						if (isset($dataItems[$item])) {
							$origvalmd5 = md5($dataItems[$item]);
							if ($valuemd5 != $origvalmd5) {
								$dataItems[$item] = $value;
								file_put_contents($filename, json_encode($dataItems));
								DbUtils::log("In $filename update item $item with value $value");
							}
						} else {
							$dataItems[$item] = $value;
							file_put_contents($filename, json_encode($dataItems));
							DbUtils::log("In $filename insert item $item with value $value");
						}
					} else {
						$dataItems = [];
						$dataItems[$item] = $value;
						file_put_contents($filename, json_encode($dataItems));
						DbUtils::log("Create $filename and insert item $item with value $value");
					}
				} catch (Exception $ex) { }
			}
		}
	}
	
	private static function updateOsAccessStatus($pdo,$timezone) {
		date_default_timezone_set($timezone);
		$date = new DateTime();
		$currentTimeStamp = $date->getTimestamp();
		
		if (DB == "mysql") {
			$sql = "SELECT id FROM %gueststatus% WHERE item=?";
			$result = DbUtils::fetchSqlAll($pdo, $sql, array('lastosaccess'));
			if (count($result) == 0) {
				$sql = "INSERT INTO %gueststatus% (date,item) VALUES(?,?)";
			} else {
				$sql = "UPDATE %gueststatus% SET date=? WHERE item=?";
			}
			DbUtils::execSql($pdo, $sql, array($currentTimeStamp,'lastosaccess'));
		} else {
			$filename = "db/" . STATUS_FILE;
			try {
				if (file_exists($filename)) {
					$lastaccess = file_get_contents($filename);
					if ($currentTimeStamp != $lastaccess) {
						file_put_contents($filename, $currentTimeStamp);
					}
				} else {
					file_put_contents($filename, $currentTimeStamp);
				}
			} catch (Exception $ex) { }
		}
	}
	
	public static function fetchQueueData($pdo) {
		if (DB == "mysql") {
                        $result = array();
			$pdo->beginTransaction();
                        try {
                                $sql = "SELECT id,date,tableid,prodid,tablecode,dailycode,extrasinjson FROM %queue%";
                                $result = DbUtils::fetchSqlAll($pdo, $sql, null);
                                DbUtils::log("Transmit " . count($result) . " items to core system from mysql queue table");
                                $sql = "DELETE FROM %queue%";
                                DbUtils::execSql($pdo, $sql, null);
                        } catch (Exception $ex) {
                                error_log("FetchQueueData not still possible: " . $ex->getMessage());
                        }
			$pdo->commit();

			return $result;
		} else {
			$filename = "db/" . QUEUE_FILE;
			if (file_exists($filename)) {
				$queueItemsInFile = file_get_contents($filename);
				$queueItems = json_decode($queueItemsInFile,true);
				DbUtils::log("Transmit " . count($queueItems) . " items to core system from file queue");
				
				$emptyContent = json_encode(array());
				file_put_contents($filename, $emptyContent);
				
				return $queueItems;
			} else {
				return array();
			}
		}
	}
}
	
if (isset($_POST["data"])) {
	$pdo = null;
	if (DB == "mysql") {
		$pdo = DbUtils::openDbAndReturnPdoStatic();
	}
	
	$data = $_POST["data"];
	
	$utfdata = base64_decode($data);
	$objFormat = json_decode($utfdata, true);

	$ret = Sync::insertSystemData($pdo,$objFormat);

	if ($ret["status"] != "OK") {
		echo json_encode($ret);
	} else {
		$queuedData = Sync::fetchQueueData($pdo);
		$ret = array("status" => "OK","msg" => $queuedData);
		echo json_encode($ret);
	}
} else {
	echo "No data transmitted!";
}