<?php

require_once 'dbutils.php';
require_once 'config.php';
defined('DB') || define ( 'DB','mysql' );

class Tables {
	public static function gettables($pdo) {
		$tables = DbUtils::getConfigItem($pdo, 'resttables', null);
		
		if (is_null($tables)) {
			return array("status" => "ERROR","msg" => "Keine Tischdefinition hinterlegt oder Tische für die Gastbestellung nicht eingerichtet.");
		}
		
		$tables = json_decode($tables,true);
		$tablesArr = array();
		foreach ($tables as $t) {
			$tablesArr[] = array("id" => $t["id"],"name" => $t["name"]);
		}
		
		$currency = DbUtils::getConfigItem($pdo, 'currency', "");
		$decpoint = DbUtils::getConfigItem($pdo, 'decpoint', ".");
		$askdaycode = DbUtils::getConfigItem($pdo, 'askdaycode', 1);
		$asktablecode = DbUtils::getConfigItem($pdo, 'asktablecode', 1);
                $guestarticleconfirm = DbUtils::getConfigItem($pdo, 'guestarticleconfirm', 1);
		$guesttimeout = DbUtils::getConfigItem($pdo, 'guesttimeout', 5) * 60;
		
		return array("status" => "OK",
		    "msg" => $tablesArr,
		    "currency" => $currency,
		    "decpoint" => $decpoint,
		    "askdaycode" => $askdaycode,
		    "asktablecode" => $asktablecode,
                    "guestarticleconfirm" => $guestarticleconfirm,
		    "timeout" => $guesttimeout);
	}
	
	public static function checkcodes($pdo,$tableid,$tablecode,$dailycode) {
		$tablecode = trim($tablecode);
		$dailycode = trim($dailycode);
		
		$askdaycode = DbUtils::getConfigItem($pdo, 'askdaycode', 1);
		$asktablecode = DbUtils::getConfigItem($pdo, 'asktablecode', 1);
		$dailycodeInDbUntrimmed = DbUtils::getConfigItem($pdo, 'dailycode', null);
		$dailycodeInDb = null;
		if (!is_null($dailycodeInDbUntrimmed)) {
			$dailycodeInDb = trim($dailycodeInDbUntrimmed);
		}
		
		$resttables = DbUtils::getConfigItem($pdo, 'resttables', null);
		
		if (is_null($resttables)) {
			return array("status" => "ERROR","msg" => "Keine Tischdefinition hinterlegt.");
		}
		
		if ($asktablecode == 1) {
			$tables = json_decode($resttables, true);
			foreach ($tables as $t) {
				DbUtils::log("CHECKE tid = " . $t["id"] . " mit tableid=" . $tableid);
				if ($t["id"] == $tableid) {
					if (trim($t["code"]) == $tablecode) {
						break;
					} else {
						return array("status" => "ERROR","msg" => "Falscher Tischcode!");
					}
				}
			}
		}
		
		if ($askdaycode == 1) {
			
			if (is_null($dailycodeInDb)) {
				return array("status" => "ERROR","msg" => "Keine Tageslosung wurde hinterlegt.");
			}

			if ($dailycode == $dailycodeInDb) {
				return array("status" => "OK");
			} else {
				return array("status" => "ERROR","msg" => "Falsche Tageslosung angegeben!");
			}
		}
		return array("status" => "OK");
	}
}

if (isset($_GET["command"])) {
	$command = $_GET["command"];
	
	$pdo = null;
	if (DB == "mysql") {
		$pdo = DbUtils::openDbAndReturnPdoStatic();
	}
	
	switch ($command) {
		case "gettables":
			$ret = Tables::gettables($pdo);
			echo json_encode($ret);
			break;
		case "checkcodes":
			$ret = Tables::checkcodes($pdo,$_POST["tableid"],$_POST["tablecode"],$_POST["dailycode"]);
			echo json_encode($ret);
			break;
		default:
			break;
	}
}

