class ExtrasUI {
        constructor(prodExtras,prodid,decpoint,currency) {
                this.prodExtras = prodExtras;
                this.prodid = prodid;
                this.decpoint = decpoint;
                this.currency = currency;
                
                // now let's create for each extra the current amount
                this.amounts = {};
                this.prodExtras.getExtras().forEach((extraEntry) => {
                        var maxamount = extraEntry.maxamount;
                        this.amounts[extraEntry.extraid] = { 
                                amount: 0,
                                maxamount: maxamount,
                                price: extraEntry.price,
                                name: extraEntry.name
                        };
                });
        }
        
        showUi() {
                var txt = '<ul data-role="listview" id="extraslist" data-divider-theme="a" data-inset="true">';
                txt += '<li data-role="list-divider" data-theme="b" data-role="heading">Extras</li>';
                this.prodExtras.getExtras().forEach((extraEntry) => {
                        var extraTxt = "<span id='amount_" + this.prodid + "_" + extraEntry.extraid + "' ></span> "
                                + toHtml(extraEntry.name) 
                                + '<span class="price"><br>'
                                + 'je ' + extraEntry.price.replace('.',this.decpoint) + " " + this.currency
                                + '</span>';
                        txt += '<li data-theme="f" data-icon="false" class="extra" id="extra_' + extraEntry.extraid + '" ><a href="#" id="extra_' + this.prodid + '" >' + extraTxt + '</a></li>';
                });
                txt += '<li data-role="list-divider" data-theme="b" data-role="heading">Preis aller Extras: <span id="extraspricesum"></span></li>';
                txt += "</ul>";
                $("#extrasarea").html(txt);
                $("#extrasdiv").show();
                $("#extrasdiv").trigger("create");
                this._bindExtraClick();
                this._bindConfirmAndCancelButtons();
                this._updateExtrasSumPrice();
        }
        
        sumPriceAllExtras() {
                var allAmountKeys = Object.keys(this.amounts);
                var sum = 0.0;
                allAmountKeys.forEach((anAmountKey) => {
                        var anAmount = this.amounts[anAmountKey];
                        sum += anAmount.amount * anAmount.price;
                });
                return sum;
        }
        
        extrasAsString() {
                var txtArr = [];
                var allAmountKeys = Object.keys(this.amounts);
                allAmountKeys.forEach((anAmountKey) => {
                        var anAmount = this.amounts[anAmountKey];
                        if (anAmount.amount > 0) {
                                txtArr[txtArr.length] = anAmount.amount + "x " + toHtml(anAmount.name);
                        }
                });
                return txtArr.join(",");
        }
        
        // create an array of the extras that can be serialized and send to core system later
        extrasAsArray() {
                var extrasArr = [];
                var allAmountKeys = Object.keys(this.amounts);
                allAmountKeys.forEach((anAmountKey) => {
                        var anAmount = this.amounts[anAmountKey];
                        if (anAmount.amount > 0) {
                                extrasArr[extrasArr.length] = { extraid: anAmountKey, amount: anAmount.amount };
                        }
                });
                return extrasArr;
        }
        
        _bindExtraClick() {
                var instance = this;
                $(".extra").off("click").on("click", function (e) {
                        e.stopImmediatePropagation();
                        e.preventDefault();
                        var extraId = this.id.split("_")[1];
                        var amountsofExtra = instance.amounts[extraId];
                        var currAmount = amountsofExtra.amount;
                        if (currAmount < amountsofExtra.maxamount) {
                                // increase
                                currAmount++;
                                $("#amount_" + instance.prodid + "_" + extraId).html(currAmount + "x");
                        } else {
                                currAmount = 0;
                                $("#amount_" + instance.prodid + "_" + extraId).html('');
                        }
                        instance.amounts[extraId].amount = currAmount;
                        instance._updateExtrasSumPrice();
                });
        }
        
        _updateExtrasSumPrice() {
                var extrasPriceSum = this.sumPriceAllExtras();
                $("#extraspricesum").html(extrasPriceSum.toFixed(2).replace('.',this.decpoint) + " " + this.currency);
        }
        
        _bindConfirmAndCancelButtons() {
                var instance = this;
                $("#extraconfirmbackbtn").off("click").on("click", function (e) {
                        e.stopImmediatePropagation();
                        e.preventDefault();
                        $("#extrasdiv").hide();
                        initProductsView();
                });
                $("#extraconfirmbtn").off("click").on("click", function (e) {
                        e.stopImmediatePropagation();
                        e.preventDefault();
                        $("#extrasdiv").hide();
                        askUserForAmount(instance);
                });
        }
}