<?php

require_once 'php/config.php';
require_once 'php/dbutils.php';

class Sync {
        public static function testAccess($data) {
                return self::checkAccessCode($data);
        }
        
        private static function checkAccessCode($data) {
                if (!isset($data["eboncode"])) {
                        error_log("No access code transmitted");
                        return array("status" => "ERROR", "msg" => "No Access code transmitted!");
                }

                $transmittedSroomCode = $data["eboncode"];
                if ($transmittedSroomCode != CODE) {
                        error_log("Wrong Access code");
                        return array("status" => "ERROR", "msg" => "Falscher Zugangscode!");
                }
                return array("status" => "OK","msg" => "Zugriff möglich");
        }
        
        public static function insertEbons($billInfos):bool {
                try {
                        $pdo = DbUtils::openDbAndReturnPdoStatic();
                        if (is_null($pdo)) {
                                error_log("PDO not established");
                                return false;
                        }
                        if (!DbUtils::doesTableExist($pdo, '%ebons%')) {
                             $sql = "
                                CREATE TABLE `%ebons%` (
                                `id` INT (3) NOT NULL AUTO_INCREMENT PRIMARY KEY,
                                `billdate` DATETIME NULL,
                                `ebonref` VARCHAR(50),
                                `data` TEXT NULL
                                ) CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDb
                                ";
                             DbUtils::execSql($pdo, $sql, null);
                             DbUtils::execSql($pdo, "ALTER TABLE %ebons% ADD INDEX ebonrefindex (ebonref)", null);
                        }

                        $sql = "DELETE FROM %ebons% where billdate < DATE_SUB(NOW(),INTERVAL " . KEEP_DAYS . " DAY)";
                        DbUtils::execSql($pdo, $sql, null);
                        
                        foreach($billInfos as $aBillInfo) {
                                $billdate = $aBillInfo["billdate"];
                                $reference = $aBillInfo["ebonreference"];
                                $data = $aBillInfo["data"];

                                $sql = "INSERT INTO %ebons% (billdate,ebonref,data) VALUES(?,?,?)";
                                DbUtils::execSql($pdo, $sql, array($billdate,$reference,$data));
                        }
                        return true;
                } catch (Exception $ex) {
                        error_log("Insert into ebons db failed: " . $ex->getMessage());
                        return false;
                }
        }      
        
}

if (isset($_POST["data"])) {
	$data = $_POST["data"];

	$utfdata = base64_decode($data);
	$objFormat = json_decode($utfdata, true);
        
        if (isset($objFormat['test'])) {
                $ret = Sync::testAccess($objFormat);
        } else if (isset($objFormat['billinfos'])) {
                $isertStatus = Sync::insertEbons($objFormat['billinfos']);
                if ($isertStatus) {
                        $ret = array("status" => "OK");
                } else {
                        $ret = array("status" => "ERROR", "msg" => "Einfügen in die eBons-Db fehlgeschlagen");
                }
        }

        echo json_encode($ret);
} else {
        echo json_encode(array("status" => "ERROR","msg" => "No data transmitted!"));
}