/*
 * Decompiled with CFR 0.152.
 */
package tseconnector.commands.sim;

import java.time.Instant;
import tseconnector.ITseStatus;
import tseconnector.commands.CommandResult;
import tseconnector.commands.ITseCommand;
import tseconnector.gen.GeneralTseCommand;

public class BaseTseCommandSimulation
extends GeneralTseCommand
implements ITseCommand {
    protected CommandResult makeTseReady(ITseStatus iTseStatus) {
        if (!iTseStatus.getLastCheckResult()) {
            return new CommandResult(false, "Last TSE check was not successful");
        }
        if (!iTseStatus.isTseTimeSet()) {
            CommandResult commandResult = this.updateTime();
            if (commandResult.isOk()) {
                iTseStatus.setTseTimeSet(true);
            } else {
                iTseStatus.setTseTimeSet(false);
                return new CommandResult(false, "Time could not be set");
            }
        }
        return new CommandResult(true, "");
    }

    protected CommandResult updateTime() {
        long l = Instant.now().getEpochSecond();
        logger.log2("Start Update Time with unixTime " + l);
        logger.log2("Logged in");
        logger.log2("Completed Update Time at TSE");
        return new CommandResult(true, "Completed Update Time at TSE");
    }

    protected static String bytesToHex(byte[] byArray) {
        char[] cArray = "0123456789ABCDEF".toCharArray();
        char[] cArray2 = new char[byArray.length * 2];
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            cArray2[i * 2] = cArray[n >>> 4];
            cArray2[i * 2 + 1] = cArray[n & 0xF];
        }
        return new String(cArray2);
    }
}

