/*
 * Decompiled with CFR 0.152.
 */
package tseconnector.commands;

import com.secureflashcard.wormapi.WormInitializationState;
import com.secureflashcard.wormapi.WormStore;
import com.secureflashcard.wormapi.WormUserId;
import java.nio.charset.StandardCharsets;
import tseconnector.ITseStatus;
import tseconnector.TseConnectorLog;
import tseconnector.commands.CommandResult;

public class TseCmdExecutor {
    public static CommandResult selftest(ITseStatus iTseStatus, boolean bl, String string, String string2, TseConnectorLog tseConnectorLog, byte[] byArray) {
        CommandResult commandResult;
        WormStore wormStore = new WormStore(string);
        try {
            if (wormStore.info().initializationState() == WormInitializationState.WORM_INIT_INITIALIZED) {
                tseConnectorLog.log0("Trying to log in before self test");
                wormStore.user_login(WormUserId.WORM_USER_ADMIN, byArray);
                wormStore.tse_registerClient(string2);
            } else if (wormStore.info().initializationState() == WormInitializationState.WORM_INIT_UNINITIALIZED) {
                tseConnectorLog.log0("Login not tried because initialization state is 'uninitialized'");
            } else if (wormStore.info().initializationState() == WormInitializationState.WORM_INIT_DECOMMISSIONED) {
                tseConnectorLog.log0("Login not tried because initialization state is 'decommissioned'");
            } else {
                tseConnectorLog.log0("Login not tried, because initialization state is not initialized");
            }
            tseConnectorLog.log0("Start Self Test");
            wormStore.tse_runSelfTest(string2);
            tseConnectorLog.log0("Completed Self Test");
            commandResult = new CommandResult(true, "Self Test completed");
        }
        catch (Throwable throwable) {
            try {
                try {
                    wormStore.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable throwable3) {
                CommandResult commandResult2;
                throwable3.printStackTrace();
                tseConnectorLog.log0("Trying to do self test without admin login and registering client");
                tseConnectorLog.log0("Start Self Test");
                WormStore wormStore2 = new WormStore(string);
                try {
                    wormStore2.tse_runSelfTest(string2);
                    tseConnectorLog.log0("Completed Self Test");
                    commandResult2 = new CommandResult(true, "Self Test completed");
                }
                catch (Throwable throwable4) {
                    try {
                        try {
                            wormStore2.close();
                        }
                        catch (Throwable throwable5) {
                            throwable4.addSuppressed(throwable5);
                        }
                        throw throwable4;
                    }
                    catch (Throwable throwable6) {
                        return new CommandResult(false, "Self test Exception: " + throwable6.getMessage());
                    }
                }
                wormStore2.close();
                return commandResult2;
            }
        }
        wormStore.close();
        return commandResult;
    }

    public static synchronized CommandResult decom(String string, String string2, TseConnectorLog tseConnectorLog) {
        CommandResult commandResult;
        WormStore wormStore = new WormStore(string);
        try {
            TseCmdExecutor.completeUnfinishedTransactions(wormStore, string2, tseConnectorLog, 0);
            tseConnectorLog.log0("Start Decom");
            wormStore.tse_decommission();
            tseConnectorLog.log0("Completed Decom");
            commandResult = new CommandResult(true, "Decommission completed");
        }
        catch (Throwable throwable) {
            try {
                try {
                    wormStore.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable throwable3) {
                throwable3.printStackTrace();
                return new CommandResult(false, "SDecom Exception: " + throwable3.getMessage());
            }
        }
        wormStore.close();
        return commandResult;
    }

    public static CommandResult completeUnfinishedTransactions(WormStore wormStore, String string, TseConnectorLog tseConnectorLog, int n) {
        if (n > 2) {
            return new CommandResult(false, "Cannot complete all unfinished transactions");
        }
        try {
            long[] lArray = wormStore.transaction_listStartedTransactions(string);
            if (lArray.length == 0) {
                return new CommandResult(true, "No unfinished transactions");
            }
            for (int i = 0; i < lArray.length; ++i) {
                tseConnectorLog.log0("There was an unfinished transaction " + lArray[i] + ". Will be completed now");
                wormStore.transaction_finish(string, lArray[i], "End".getBytes(StandardCharsets.UTF_8), "Complete unfinished transaction");
            }
            return new CommandResult(true, "Finished " + lArray.length + " transactions");
        }
        catch (Throwable throwable) {
            tseConnectorLog.log0("Start Self Test");
            wormStore.tse_runSelfTest(string);
            tseConnectorLog.log0("Completed Self Test");
            return TseCmdExecutor.completeUnfinishedTransactions(wormStore, string, tseConnectorLog, n + 1);
        }
    }
}

