/*
 * Decompiled with CFR 0.152.
 */
package tseconnector.commands;

import com.secureflashcard.wormapi.WormAuthenticationFailedException;
import com.secureflashcard.wormapi.WormInitializationState;
import com.secureflashcard.wormapi.WormStore;
import com.secureflashcard.wormapi.WormUserId;
import java.time.Instant;
import tseconnector.ITseStatus;
import tseconnector.commands.CommandResult;
import tseconnector.commands.ITseCommand;
import tseconnector.gen.GeneralTseCommand;

public class BaseTseCommand
extends GeneralTseCommand
implements ITseCommand {
    protected CommandResult makeTseReady(ITseStatus iTseStatus) {
        if (!iTseStatus.getLastCheckResult()) {
            return new CommandResult(false, "Last TSE check was not successful");
        }
        if (!iTseStatus.isTseTimeSet()) {
            CommandResult commandResult = this.updateTime();
            if (commandResult.isOk()) {
                iTseStatus.setTseTimeSet(true);
                return this.registerClient(this.clientid);
            }
            iTseStatus.setTseTimeSet(false);
            return commandResult;
        }
        return new CommandResult(true, "");
    }

    protected CommandResult registerClient(String string) {
        CommandResult commandResult;
        WormStore wormStore = new WormStore(this.mountPoint);
        try {
            wormStore.tse_registerClient(string);
            commandResult = new CommandResult(true, "Completed Register Client with id " + string + " at TSE");
        }
        catch (Throwable throwable) {
            try {
                try {
                    wormStore.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable throwable3) {
                throwable3.printStackTrace();
                return new CommandResult(false, "Register Client resulted in an exception: " + throwable3.getMessage());
            }
        }
        wormStore.close();
        return commandResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected CommandResult updateTime() {
        try (WormStore wormStore = new WormStore(this.mountPoint);){
            long l = Instant.now().getEpochSecond();
            logger.log2("Start Update Time with unixTime " + l);
            if (wormStore.info().initializationState() != WormInitializationState.WORM_INIT_INITIALIZED) {
                CommandResult commandResult = new CommandResult(false, "WormStore not initialized - do notrtry to log in. Stopping update time.");
                return commandResult;
            }
            wormStore.user_login(WormUserId.WORM_USER_ADMIN, this.pin);
            logger.log2("Logged in");
            wormStore.tse_updateTime(l);
            logger.log2("Completed Update Time at TSE");
            CommandResult commandResult = new CommandResult(true, "Completed Update Time at TSE");
            return commandResult;
        }
        catch (WormAuthenticationFailedException wormAuthenticationFailedException) {
            String string = "remaining retries = " + wormAuthenticationFailedException.remainingRetries;
            String string2 = wormAuthenticationFailedException.getMessage();
            logger.log0("Authentication error: " + string2 + " - " + string);
            return new CommandResult(false, "Authentication issue: " + string2 + " - " + string);
        }
        catch (Throwable throwable3) {
            throwable3.printStackTrace();
            return new CommandResult(false, "Update Time resulted in an exception: " + throwable3.getMessage());
        }
    }

    protected static String bytesToHex(byte[] byArray) {
        char[] cArray = "0123456789ABCDEF".toCharArray();
        char[] cArray2 = new char[byArray.length * 2];
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            cArray2[i * 2] = cArray[n >>> 4];
            cArray2[i * 2 + 1] = cArray[n & 0xF];
        }
        return new String(cArray2);
    }
}

