/*
 * Decompiled with CFR 0.152.
 */
package tseconnector;

import java.time.Instant;
import tseconnector.ITseStatus;
import tseconnector.TseConnectorLog;
import tseconnector.tseconnector;

public class TseStatus
implements ITseStatus {
    private long lastSuccessfulCheck = 0L;
    private long lastTimeSet = 0L;
    private long maxSecondsBetweenTimeUpdates = 0L;
    private int serverPort;
    private boolean isBusy = false;
    private boolean lastCheckResult = true;
    private tseconnector.Mode mode = tseconnector.Mode.Normal;
    private TseConnectorLog logger = null;
    private String tarExportFile = "/tmp/tsetarexport";

    @Override
    public void setLogger(TseConnectorLog tseConnectorLog) {
        this.logger = tseConnectorLog;
    }

    @Override
    public void setServerPort(int n) {
        this.serverPort = n;
    }

    @Override
    public int getServerPort() {
        return this.serverPort;
    }

    @Override
    public void setSyncDurationTime(long l) {
        this.maxSecondsBetweenTimeUpdates = l;
    }

    private void logifpossible_level2(String string) {
        if (this.logger != null) {
            this.logger.log2(string);
        }
    }

    @Override
    public boolean isCheckUseful() {
        int n;
        long l = Instant.now().getEpochSecond();
        if (l - this.lastSuccessfulCheck > (long)(n = 1800)) {
            this.logifpossible_level2("isCheckUseful = true: current = " + l + ", lastSucces=" + this.lastSuccessfulCheck);
            return true;
        }
        this.logifpossible_level2("isCheckUseful = false: current = " + l + ", lastSucces=" + this.lastSuccessfulCheck);
        return false;
    }

    @Override
    public void setSuccessfulCheckIsDone() {
        this.lastSuccessfulCheck = Instant.now().getEpochSecond();
    }

    @Override
    public boolean isTseTimeSet() {
        long l = Instant.now().getEpochSecond();
        return l - this.lastTimeSet <= this.maxSecondsBetweenTimeUpdates;
    }

    @Override
    public void setTseTimeSet(boolean bl) {
        this.lastTimeSet = !bl ? 0L : Instant.now().getEpochSecond();
    }

    @Override
    public void setMode(tseconnector.Mode mode) {
        this.mode = mode;
    }

    @Override
    public tseconnector.Mode getMode() {
        return this.mode;
    }

    @Override
    public void setIsBusy(boolean bl) {
        this.isBusy = bl;
    }

    @Override
    public boolean isBusy() {
        return this.isBusy;
    }

    @Override
    public boolean getLastCheckResult() {
        return this.lastCheckResult;
    }

    @Override
    public void setLastCheckResult(boolean bl) {
        this.lastCheckResult = bl;
    }

    @Override
    public void setTarExportFile(String string) {
        this.tarExportFile = string;
    }

    @Override
    public String getTarExportFile() {
        return this.tarExportFile;
    }
}

