/*
 * Decompiled with CFR 0.152.
 */
package tseconnector;

import java.io.File;
import java.util.ArrayList;
import tseconnector.TseConnectorLog;

public class TseLocator {
    private boolean isWindowsSystem() {
        String string = System.getProperty("os.name");
        return string.toLowerCase().startsWith("windows");
    }

    private ArrayList<String> getDirsInPath(String string) {
        File[] fileArray = new File(string).listFiles(File::isDirectory);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (fileArray != null) {
            for (File file : fileArray) {
                arrayList.add(file.getPath());
            }
        }
        return arrayList;
    }

    private boolean checkExistenceOfFile(String string, String string2) {
        File file = new File(string + File.separator + string2);
        return file.exists();
    }

    private boolean checkForTseDeviceInCertainDir(String string) {
        return this.checkExistenceOfFile(string, "TSE_INFO.DAT") || this.checkExistenceOfFile(string, "tse_info.dat") || this.checkExistenceOfFile(string, "TSE_COMM.DAT") || this.checkExistenceOfFile(string, "tse_comm.dat") || this.checkExistenceOfFile(string, "TSE_TAR.001") || this.checkExistenceOfFile(string, "tse_tar.001");
    }

    private String findTseInDirRecursive(String string) {
        if (this.checkForTseDeviceInCertainDir(string)) {
            return string;
        }
        ArrayList<String> arrayList = this.getDirsInPath(string);
        for (String string2 : arrayList) {
            String string3 = this.findTseInDirRecursive(string2);
            if (string3 == null) continue;
            return string3;
        }
        return null;
    }

    private String findTseInLinux() {
        String[] stringArray;
        for (String string : stringArray = new String[]{"/mnt", "/mount", "/media"}) {
            String string2 = this.findTseInDirRecursive(string);
            if (string2 == null) continue;
            return string2;
        }
        return null;
    }

    private String findTseInWindows() {
        File[] fileArray;
        for (File file : fileArray = File.listRoots()) {
            if (!this.checkForTseDeviceInCertainDir(file.getPath())) continue;
            return file.getPath();
        }
        return null;
    }

    public String findTse() {
        TseConnectorLog tseConnectorLog = new TseConnectorLog(true);
        String string = null;
        if (this.isWindowsSystem()) {
            tseConnectorLog.log0("Suche TSE Hardware in Windows-System...");
            string = this.findTseInWindows();
        } else {
            tseConnectorLog.log0("Suche TSE Hardware in Linux-Systen...");
            string = this.findTseInLinux();
        }
        return string;
    }
}

